package game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BusyPanel extends JPanel implements Runnable {
	
	public static final int SAVE = 0;
	public static final int LOAD = 1;
	public static final int CHECK = 2;
	public static final int PREPARE = 3;
	public static final int PACK = 4;
	public static final int UNPACK = 5;
	
	private ArrayList<BufferedImage> savingImages;
	private ArrayList<BufferedImage> loadingImages;
	private ArrayList<BufferedImage> checkingImages;
	private ArrayList<BufferedImage> preparingImages;
	private ArrayList<BufferedImage> packingImages;
	private ArrayList<BufferedImage> unpackingImages;
	//private JLabel mainLabel;
	private ArrayList<BufferedImage> whichImageSet;
	private int currentFrame = 0;
	private int currentCode = 0;
	private Image dummyDeleteMeLaterImage;
	
	private static JFrame theFrame;
	private static BusyPanel instance = null;
	private static Thread thread;
	
	private static boolean isInitialized = false;
	private static boolean haveShownBoxBefore = false;
	
	private Graphics canvasGraphics;
	private Image canvasBuffer;
	
	private boolean isRunning = false;
	private boolean shouldBeRunning = false;
	
	private BusyPanel(ImageObserver io) {
		
//		System.out.println("&&&&&&&&&&&&&& now in the constructor for BusyPanel");
		
		isRunning = false;
		shouldBeRunning = false;
		
		savingImages = new ArrayList<BufferedImage>();
		for(int i = 1; i <= 19; i++) {
//			savingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present save " + i + ".GIF")).getImage());
			CustomImageDataII tempImage = new CustomImageDataII("/images/present save " + i + ".GIF", null, io);
			savingImages.add(tempImage.getImage());
		}
		for(int i = 0; i <= 10; i++) {
//			savingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present save 1.GIF")).getImage());
//			CustomImageDataII saveImage = new CustomImageDataII("/images/present save " + i + ".GIF", null, io);
			savingImages.add(savingImages.get(0));
		}
		
		loadingImages = new ArrayList<BufferedImage>();
		for(int i = 1; i <= 19; i++) {
//			loadingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present load " + i + ".GIF")).getImage());
			CustomImageDataII tempImage = new CustomImageDataII("/images/present load " + i + ".GIF", null, io);
			loadingImages.add(tempImage.getImage());
		}
		for(int i = 0; i <= 10; i++) {
//			loadingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present load 1.GIF")).getImage());
			loadingImages.add(loadingImages.get(0));
		}
		
		checkingImages = new ArrayList<BufferedImage>();
		for(int i = 1; i <= 14; i++) {
//			checkingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present check " + i + ".GIF")).getImage());
			CustomImageDataII tempImage = new CustomImageDataII("/images/present check " + i + ".GIF", null, io);
			checkingImages.add(tempImage.getImage());
		}
		for(int i = 0; i <= 10; i++) {
//			checkingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present check 1.GIF")).getImage());
			checkingImages.add(checkingImages.get(0));
		}
		
		
		preparingImages = new ArrayList<BufferedImage>();
		for(int i = 1; i <= 14; i++) {
//			preparingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present prepare " + i + ".GIF")).getImage());
			CustomImageDataII tempImage = new CustomImageDataII("/images/present prepare " + i + ".GIF", null, io);
			preparingImages.add(tempImage.getImage());
		}
		for(int i = 0; i <= 10; i++) {
//			preparingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present prepare 1.GIF")).getImage());
			preparingImages.add(preparingImages.get(0));
		}
		
				
		packingImages = new ArrayList<BufferedImage>();
		for(int i = 1; i <= 30; i++) {
//			packingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present packing " + i + ".GIF")).getImage());
			CustomImageDataII tempImage = new CustomImageDataII("/images/present packing " + i + ".GIF", null, io);
			packingImages.add(tempImage.getImage());
		}
		for(int i = 0; i <= 10; i++) {
//			packingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present packing 1.GIF")).getImage());
			packingImages.add(packingImages.get(0));
		}
		
		
		unpackingImages = new ArrayList<BufferedImage>();
		for(int i = 1; i <= 25; i++) {
//			unpackingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present unpacking " + i + ".GIF")).getImage());
			CustomImageDataII tempImage = new CustomImageDataII("/images/present unpacking " + i + ".GIF", null, io);
			unpackingImages.add(tempImage.getImage());
		}
		for(int i = 0; i <= 10; i++) {
//			unpackingImages.add(new ImageIcon(BusyPanel.class.getResource("/images/present unpacking 1.GIF")).getImage());
			unpackingImages.add(unpackingImages.get(0));
		}
		
		
//		System.out.println("just got unpackingImages loaded...");
		
		dummyDeleteMeLaterImage = new ImageIcon(BusyPanel.class.getResource("/images/present check 1.GIF")).getImage();
		
		
		if(canvasBuffer == null) {
			canvasBuffer = createImage(128, 64);
			if(canvasBuffer == null) {
				//System.err.println("ERROR:  canvasBuffer was null");
			} else {
				canvasGraphics = canvasBuffer.getGraphics();
			}
		}
		
		whichImageSet = null;
		
		
		this.setPreferredSize(new Dimension(128, 64));
		this.setMinimumSize(new Dimension(128, 64));
		this.setMaximumSize(new Dimension(128, 64));
		
//		System.out.println("about to call primeAllImages...");
		primeAllImages();
	}
	
	
	public void setImageSet(int imageCode) {
		switch(imageCode) {
		case SAVE:
			whichImageSet = savingImages;
			break;
		case LOAD:
			whichImageSet = loadingImages;
			break;
		case CHECK:
			whichImageSet = checkingImages;
			break;
		case PREPARE:
			whichImageSet = preparingImages;
			break;
		case PACK:
			whichImageSet = packingImages;
			break;
		case UNPACK:
			whichImageSet = unpackingImages;
			break;
		}
	}
	
	
	public void run() {
		
//		System.out.println("now at the start of run...");
		
		isRunning = true;
		
		long stopTime = System.currentTimeMillis() + 2500L;
		
		while((canvasBuffer == null || canvasBuffer == null) && System.currentTimeMillis() < stopTime) {
//			canvasBuffer = createImage(128, 64);
			canvasBuffer = new BufferedImage(128, 64, BufferedImage.TYPE_INT_ARGB);
			if(canvasBuffer != null) {
				canvasGraphics = canvasBuffer.getGraphics();
			}
		}
		
//		System.out.println("after the while-loop that has that 2.5 second delay...");
		
		stopTime = System.currentTimeMillis() + 500L;
		
		while(!theFrame.isVisible() && stopTime > System.currentTimeMillis());
		
//		System.out.println("after the while-loop that has that 0.5 second delay...");
		
		if(canvasBuffer == null) {
			//System.err.println("ERROR:  canvasBuffer was STILL null");
			isRunning = false;
			return;
		}
		
		if(canvasGraphics == null) {
			//System.err.println("ERROR:  canvasBuffer was STILL null");
			isRunning = false;
			return;
		}
		
		currentFrame = 0;
		
//		if(canvasGraphics == null)
			//System.err.println("canvasGraphics was null!");
		
		long startOfWait;
		long currentTime;
		
//		System.out.println("about to enter the while-loop; theFrame.isVisible()? " + theFrame.isVisible() 
//				+ ",  whichImageSet != null?  " +  (whichImageSet != null) 
//				+ ", canvasGraphics != null? "  + (canvasGraphics != null));
		
		try {Thread.sleep(10L);} catch(Exception e) {}
		
		long startOfWhileLoop = System.currentTimeMillis();
		
		shouldBeRunning = true;
		
		ArrayList<BufferedImage> currentImageSet = null;
		
		while(theFrame.isVisible() && whichImageSet != null && canvasGraphics != null && shouldBeRunning) {
			
//			System.out.println("at the start of the while-loop, the difference between the last start of the while-loop and the current timestamp is:  " + (System.currentTimeMillis() - startOfWhileLoop));
			
			currentImageSet = whichImageSet;
			
			startOfWhileLoop = System.currentTimeMillis();
			
			canvasGraphics.drawImage(currentImageSet.get(currentFrame), 0, 0, this);
			Color origColor = canvasGraphics.getColor();
//			canvasGraphics.setColor(Color.RED);
//			canvasGraphics.drawRect(10, 10, 20, 20);
			canvasGraphics.setColor(origColor);
			
//			System.out.println("about to call repaint...");
			
			repaint();
			paintImmediately(0, 0, 128, 64);
//			System.out.println("just called repaint; there really should be something from paintComponent in there...");
			
			
			currentFrame++;
			if(currentFrame >= currentImageSet.size())
				currentFrame = 0;
			
			try {
				startOfWait = System.currentTimeMillis();
				currentTime = startOfWait;
//				System.out.println("startOfWait is: " + startOfWait + "; let's see how many centiseconds it really takes...");
				while(currentTime < startOfWait + 100L) {
					Thread.sleep(100L);
					currentTime = System.currentTimeMillis();
//					System.out.println("-0-0-0-0-0-0- sleeping for a centisecond; currentTime: " + currentTime);
				}
//				System.out.println("start of wait: " + startOfWait + "; wait ended at: " + currentTime);
			} catch (InterruptedException e) {
//				System.out.println("88888888888888888888888888888888888888888888interrupted");
			}
//			System.out.println("  =======================  NOW IN THE RUN METHOD!!!  whichImages: " + this.currentCode + ", and frame: " + currentFrame);
		}
		
//		JOptionPane.showMessageDialog(null, "<html><><>DELME at the end of the run method!  <br>theFrame.isVisible()? " + theFrame.isVisible() 
//				+ "<br>whichImageSet != null? "+(whichImageSet != null)
//				+ "<br>canvasGraphics != null? "+(canvasGraphics != null)
//				+ "<br>shouldBeRunning? "+shouldBeRunning+" </html>");
		//System.err.println("========END OF RUN METHOD========");
		//System.err.println("========END OF RUN METHOD========");
		isRunning = false;
		shouldBeRunning = false;
		
	}
	
	public void paintComponent(Graphics g) {
//		System.out.println("now in paintComponent...");
		super.paintComponent(g);
		if(canvasBuffer != null) {
//			g.drawImage(whichImageSet.get(currentFrame), 0, 0, this);
			g.drawImage(canvasBuffer,0, 0, this);
//			Color o = g.getColor();
//			g.setColor(Color.RED);
//			g.drawRect(10, 10, 20, 20);
//			g.setColor(o);
		} else {
			//System.err.println("canvasBuffer was null!  Unable to paintComponent!");
		}
		
	}
	
	
	public static void initialize(ImageObserver io) {
		
		theFrame = new JFrame();
		theFrame.setBackground(Color.BLACK);
//		theFrame.setUndecorated(true);
		theFrame.setResizable(false);
		theFrame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		
		theFrame.setPreferredSize(new Dimension(134, 96));
		theFrame.setMinimumSize(new Dimension(134, 96));
		theFrame.setMaximumSize(new Dimension(134, 96));
		
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		
		theFrame.setLocation(screenSize.width / 2 - 66, screenSize.height / 2 - 33);
		
		if(instance == null)
			instance = new BusyPanel(io);
		
		theFrame.setContentPane(instance);
		
		theFrame.addWindowListener(new WindowListener() {

			public void windowOpened(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}

			public void windowClosing(WindowEvent arg0) {
//				System.out.println("I hope that it came when the window's little red X was clicked...");
				theFrame.setVisible(false);
			}

			public void windowClosed(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}

			public void windowIconified(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}

			public void windowDeiconified(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}

			public void windowActivated(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}

			public void windowDeactivated(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
		});
		
		isInitialized = true;
		
	}
	
	
	public static void showWaitBox(int whichImages, ImageObserver io) {
		
		if(!isInitialized)
			initialize(io);
		
		while(instance.isRunning) {
			Thread.yield();
//			System.out.println("isRunning is still true in showWaitBox!!!");
		}
			
		
		instance.currentCode = whichImages;
		instance.setImageSet(whichImages);
		thread = new Thread(instance);
		thread.start();
		
		theFrame.setVisible(true);
		
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		
//		theFrame.setLocation(screenSize.width / 2 - 66, screenSize.height / 2 - 33);
		
		theFrame.setLocation(400, 400);
		
		
	}
	
	public static void hideWaitBox() {
		
		instance.shouldBeRunning = false;
		theFrame.setVisible(false);
		instance.whichImageSet = null;
		
		while(instance.isRunning)
			Thread.yield();
//			System.out.println("...it's still running; I'm waiting in hideWaitBox...");
		
		
	}
	
	public static void endAll() {
		
		if(theFrame != null)
			theFrame.dispose();
		
	}
	
	
	public void primeAllImages() {
		
//		System.out.println("now in primeAllImages!");
		
		BufferedImage bi = new BufferedImage(100, 100, BufferedImage.TYPE_INT_ARGB);
		
		Graphics g = bi.getGraphics();
		
		for(Image i : loadingImages) {
//			if(i == null)
//				System.out.println("problem:  image was null!");
			g.drawImage(i, 0, 0, null);
		}
		
		for(Image i : savingImages) {
			g.drawImage(i, 0, 0, null);
		}
		
		for(Image i : packingImages) {
			g.drawImage(i, 0, 0, null);
		}
		
		for(Image i : preparingImages) {
			g.drawImage(i, 0, 0, null);
		}
		
		for(Image i : unpackingImages) {
			g.drawImage(i, 0, 0, null);
		}
		
		for(Image i : checkingImages) {
			g.drawImage(i, 0, 0, null);
		}
		
	}
	/*
	public static void primeThePump() {
		
		
		showWaitBox(CHECK);
		try {
			Thread.sleep(30000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		hideWaitBox();
		
		JOptionPane.showMessageDialog(null, "just primed the check...", "priming", JOptionPane.INFORMATION_MESSAGE);
		
		showWaitBox(LOAD);
		try {
			Thread.sleep(30000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		hideWaitBox();
		
		JOptionPane.showMessageDialog(null, "just primed the load...", "priming", JOptionPane.INFORMATION_MESSAGE);
		
		
		showWaitBox(SAVE);
		try {
			Thread.sleep(30000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		hideWaitBox();
		
		
		JOptionPane.showMessageDialog(null, "just primed the save...let's hope it's all primed!", "priming", JOptionPane.INFORMATION_MESSAGE);
		
	}
	
	public static void main(String [] args) {
		
		showWaitBox(LOAD);
		
		try {
			Thread.sleep(6000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		
		hideWaitBox();
		
		showWaitBox(SAVE);
		
		try {
			Thread.sleep(6000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		
		hideWaitBox();
		
		
		showWaitBox(CHECK);
		try {
			Thread.sleep(6000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		hideWaitBox();
		
		showWaitBox(PACK);
		try {
			Thread.sleep(6000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		hideWaitBox();
		
		showWaitBox(PREPARE);
		try {
			Thread.sleep(6000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		hideWaitBox();
		
		showWaitBox(UNPACK);
		try {
			Thread.sleep(6000L);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		hideWaitBox();
		
		endAll();
		
	}
	
	
	*/
}
